
#Import "<std>"
Using std..

class Vector3
	Field x:Double
	Field y:Double
	Field z:Double
	
	Method New()
	End
	
	Method New( t:Double )
		x = t
		y = t
		z = t
	End
	
	Method New( x:Double, y:Double, z:Double )
		self.x = x
		Self.y = y
		Self.z = z
	End
	
	Property X:Double()
		Return x
	Setter( x:Double )
		Self.x = x
	End
	
	Property Y:Double()
		Return y
	Setter( y:Double )
		Self.y = y
	End
	
	Property Z:Double()
		Return z
	Setter( z:Double )
		Self.z = z
	End
	
	Operator-:Vector3()
		Return New Vector3( -x,-y,-z )
	End
	
	Operator*:Vector3( v:Vector3 )
		Return New Vector3( x*v.x,y*v.y,z*v.z )
	End
	
	Operator/:Vector3( v:Vector3 )
		Return New Vector3( x/v.x,y/v.y,z/v.z )
	End
	
	Operator+:Vector3( v:Vector3 )
		Return New Vector3( x+v.x,y+v.y,z+v.z )
	End
	
	Operator-:Vector3( v:Vector3 )
		Return New Vector3( x-v.x,y-v.y,z-v.z )
	End
	
	Operator*:Vector3( s:Double )
		Return New Vector3( x*s,y*s,z*s )
	End
	
	Operator/:Vector3( s:Double )
		Return New Vector3( x/s,y/s,z/s )
	End
	
	Operator+:Vector3( s:Double )
		Return New Vector3( x+s,y+s,z+s )
	End
	
	Operator-:Vector3( s:Double )
		Return New Vector3( x-s,y-s,z-s )
	End
	
	Property Length:Double()
		Return Sqrt( x*x+y*y+z*z )
	End

	Method Dot:Double( v:Vector3 )
		Return x*v.x + y*v.y + z*v.z
	End

	
	Method Cross:Vector3( v:Vector3 )
		Return new Vector3(y * v.z - z * v.y, z * v.x - x * v.z, x * v.y - y * v.x)
	End method

	
	Method Normalize:Vector3()
		Return Self/Length
	End
	
	Method Blend:Vector3( v:Vector3,alpha:Double )
		Return New Vector3( (v.x-x)*alpha+x,(v.y-y)*alpha+y,(v.z-z)*alpha+z )
	End
	
	Method ToString:String()
		Return "Vector3("+x+","+y+","+z+")"
	End
End class